from calibre.ptempfile import PersistentTemporaryFile
class AdvancedUserRecipe1276486274(BasicNewsRecipe):
    title          = u'Today Online - Singapore'
    publisher             = 'MediaCorp Press Ltd - Singapore'
    category              = 'news, Singapore'
    oldest_article = 7
    max_articles_per_feed = 100
    remove_javascript = True
    use_embedded_content   = False
    no_stylesheets = True
    language = 'en'
    temp_files = []
    articles_are_obfuscated = True
    masthead_url = 'http://www.todayonline.com/App_Themes/Default/images/icons/TodayOnlineLogo.gif'
    conversion_options = {'linearize_tables':True} 
    extra_css = '''
                   .author{font-style: italic; font-size: small}
                   .date{font-style: italic; font-size: small}
                   .Headline{font-weight: bold; font-size: xx-large}
                   .headerStrap{font-weight: bold; font-size: x-large; font-syle: italic}
                   .bodyText{font-size: 4px;font-family: Times New Roman;}
                '''
    keep_only_tags = [
                                       dict(name='div', attrs={'id':['fullPrintBodyHolder']})        
                        ]       
    remove_tags_after = [  dict(name='div', attrs={'class':'button'})]


    remove_tags = [
                    dict(name='div', attrs={'class':['url','button']})
                         ]     
    feeds          = [
                         (u'Singapore', u'http://www.todayonline.com/RSS/Singapore'),
                         (u'Hot News', u'http://www.todayonline.com/RSS/Hotnews'), 
                        (u'Today Online', u'http://www.todayonline.com/RSS/Todayonline'),
                        (u'Voices', u'http://www.todayonline.com/RSS/Voices'),
                        (u'Commentary', u'http://www.todayonline.com/RSS/Commentary'),
                        (u'World', u'http://www.todayonline.com/RSS/World'),
                        (u'Business', u'http://www.todayonline.com/RSS/Business'),
                        (u'Column', u'http://www.todayonline.com/RSS/Columns'),   
                      ]

    def get_obfuscated_article(self, url):
        br = self.get_browser()
        br.open(url)
        response = br.follow_link(url_regex = r'/Print/', nr = 0) 
        html = response.read()
        self.temp_files.append(PersistentTemporaryFile('_fa.html'))
        self.temp_files[-1].write(html)
        self.temp_files[-1].close()
        return self.temp_files[-1].name

    def preprocess_html(self, soup):
        for item in soup.findAll(style=True):
           del item['style']
        return soup